<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SessionIndexGPW
 *
 * @ORM\Table(name="index_gpw_sessions")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\SessionIndexGPWRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class SessionIndexGPW
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="indexGPWId", type="integer")
     */
    private $indexGPWId;

    /**
     * @var \Date
     *
     * @ORM\Column(name="date", type="date")
     */
    private $date;

    /**
     * @var float
     *
     * @ORM\Column(name="open", type="float")
     */
    private $open;

    /**
     * @var float
     *
     * @ORM\Column(name="high", type="float")
     */
    private $high;

    /**
     * @var float
     *
     * @ORM\Column(name="low", type="float")
     */
    private $low;

    /**
     * @var float
     *
     * @ORM\Column(name="close", type="float")
     */
    private $close;

    /**
     * @var float
     *
     * @ORM\Column(name="volume", type="float")
     */
    private $volume;

    /**
     * @var float
     *
     * @ORM\Column(name="oi", type="float")
     */
    private $oi;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createAt", type="datetime")
     */
    private $createAt;

    /**
     * @ORM\ManyToOne(targetEntity="IndexGPW",inversedBy="sessions")
     * @ORM\JoinColumn(name="indexGPWId", referencedColumnName="id")
     */
    private $indexGPW;

    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createAt = new \DateTime();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set indexGPWId
     *
     * @param integer $indexGPWId
     * @return SessionIndexGPW
     */
    public function setIndexGPWId($indexGPWId)
    {
        $this->indexGPWId = $indexGPWId;
    
        return $this;
    }

    /**
     * Get indexGPWId
     *
     * @return integer 
     */
    public function getIndexGPWId()
    {
        return $this->indexGPWId;
    }

    /**
     * Set date
     *
     * @param \DateTime $date
     * @return SessionIndexGPW
     */
    public function setDate($date)
    {
        $this->date = $date;
    
        return $this;
    }

    /**
     * Get date
     *
     * @return \DateTime 
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * Set open
     *
     * @param float $open
     * @return SessionIndexGPW
     */
    public function setOpen($open)
    {
        $this->open = $open;
    
        return $this;
    }

    /**
     * Get open
     *
     * @return float 
     */
    public function getOpen()
    {
        return $this->open;
    }

    /**
     * Set high
     *
     * @param float $high
     * @return SessionIndexGPW
     */
    public function setHigh($high)
    {
        $this->high = $high;
    
        return $this;
    }

    /**
     * Get high
     *
     * @return float 
     */
    public function getHigh()
    {
        return $this->high;
    }

    /**
     * Set low
     *
     * @param float $low
     * @return SessionIndexGPW
     */
    public function setLow($low)
    {
        $this->low = $low;
    
        return $this;
    }

    /**
     * Get low
     *
     * @return float 
     */
    public function getLow()
    {
        return $this->low;
    }

    /**
     * Set close
     *
     * @param float $close
     * @return SessionIndexGPW
     */
    public function setClose($close)
    {
        $this->close = $close;
    
        return $this;
    }

    /**
     * Get close
     *
     * @return float 
     */
    public function getClose()
    {
        return $this->close;
    }

    /**
     * Set volume
     *
     * @param float $volume
     * @return SessionIndexGPW
     */
    public function setVolume($volume)
    {
        $this->volume = $volume;
    
        return $this;
    }

    /**
     * Get volume
     *
     * @return float 
     */
    public function getVolume()
    {
        return $this->volume;
    }

    /**
     * Set oi
     *
     * @param float $oi
     * @return SessionIndexGPW
     */
    public function setOi($oi)
    {
        $this->oi = $oi;
    
        return $this;
    }

    /**
     * Get oi
     *
     * @return float 
     */
    public function getOi()
    {
        return $this->oi;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return SessionIndexGPW
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }

    /**
     * Set indexGPW
     *
     * @param \Import\ApiBundle\Entity\IndexGPW $indexGPW
     * @return SessionIndexGPW
     */
    public function setIndexGPW(\Import\ApiBundle\Entity\IndexGPW $indexGPW = null)
    {
        $this->indexGPW = $indexGPW;
    
        return $this;
    }

    /**
     * Get indexGPW
     *
     * @return \Import\ApiBundle\Entity\IndexGPW 
     */
    public function getIndexGPW()
    {
        return $this->indexGPW;
    }
}